package zipdemo;
import java.io.*;
import java.util.*;
import java.util.zip.*;


public final class zipdemo
{
	/*
	This function is called by the zipDemo library to add files to the current zip archive.
	The following creates a new copy of the current archive and copies the content from the
	current archive to the new 'tmp' archive. The entry name (specified by pEntryname) is then added to the new tmp archive.
	Once the operation is complete, the current zip file is deleted and the 'tmp' file is renamed to the name
	of the current zip file.
	
	*/
	public void addfile(String pFilename, String pEntryName, byte pData[])
	{
		File lfile = new File(pFilename);
		try
		{
			if (lfile.exists())
			{
				String ltmpname = null;
				String lname = null;
				ltmpname = pFilename.substring(0,pFilename.lastIndexOf('.'));
				ltmpname = ltmpname+".tmp";
				FileOutputStream fos = new FileOutputStream(ltmpname,true);
				ZipOutputStream zos = new ZipOutputStream(fos);
			  ZipFile zf=new ZipFile(lfile);
			  ZipEntry entry = null;
				Enumeration<?> e = zf.entries();
				while (e.hasMoreElements())
				{
					byte[] entrydata = null;
			  	entry = (ZipEntry)e.nextElement();
			  	if (entry != null)
			  	{
			  		entrydata = getentry(zf,entry);
			  		lname = entry.getName();
			  		if (pEntryName.compareTo(lname)!=0) putentry(zos,entry.getName(),entrydata);
			  	}
				}
			 	putentry(zos,pEntryName,pData);			
			 	zos.flush();
			 	zos.close();
			 	fos.close();
			 	zf.close();		
			 	lfile.delete();
			 	File lsrc = new File(ltmpname);
			 	lsrc.renameTo(lfile);				
			}
			else
			{
				FileOutputStream fos = new FileOutputStream(pFilename,true);
				ZipOutputStream zos = new ZipOutputStream(fos);
			 	putentry(zos,pEntryName,pData);
			 	zos.flush();
			 	zos.close();
			 	fos.close();
			}
		}
		catch (Exception e)
		{
			System.out.println("addfile: ERROR, Exception: "+e);
		}
	}


	/*
	This function is called by the zipDemo library to remove files from the current zip archive.
	The following creates a new copy of the current archive and copies the content from the
	current archive to the new 'tmp' archive. The entry name (specified by pEntryname) is not copied.
	Once the operation is complete, the current zip file is deleted and the 'tmp' file is renamed to the name
	of the current zip file.
	*/
	public void removefile(String pFilename, String pEntryName)
	{
		File lfile = new File(pFilename);
		try
		{
			if (lfile.exists())
			{
				String lentry = null;
				String ltmpname = null;
				ltmpname = pFilename.substring(0,pFilename.lastIndexOf('.'));
				ltmpname = ltmpname+".tmp";
				FileOutputStream fos = new FileOutputStream(ltmpname,true);
				ZipOutputStream zos = new ZipOutputStream(fos);
			  ZipFile zf=new ZipFile(lfile);
			  ZipEntry entry = null;
				Enumeration<?> e = zf.entries();
				while (e.hasMoreElements())
				{
					byte[] entrydata = null;
			  	entry = (ZipEntry)e.nextElement();
			  	if (entry != null)
			  	{
			  		entrydata = getentry(zf,entry);
			  		lentry = entry.getName();
			  		if (pEntryName.compareTo(lentry)!=0) putentry(zos,entry.getName(),entrydata);
			  	}
				}
			 	zos.flush();
			 	zos.close();
			 	fos.close();						
			 	zf.close();		
			 	lfile.delete();
			 	File lsrc = new File(ltmpname);
			 	lsrc.renameTo(lfile);				
			}
		}
		catch (Exception e)
		{
			System.out.println("addfile: ERROR, Exception: "+e);
		}
	}


	/*
	The following function writes a specified entry to the file pFilename.
	*/
	public void putentry(String pFilename, String pEntryName, byte pData[])
	{
		try
		{
			FileOutputStream fos = new FileOutputStream(pFilename,true);
			ZipOutputStream zos = new ZipOutputStream(fos);
			ZipEntry entry = new ZipEntry(pEntryName);
			zos.putNextEntry(entry);
			
			byte[] buffer = new byte[1024];
			int bytecount = 0;
			ByteArrayInputStream bis = new ByteArrayInputStream(pData);
			while ((bytecount = bis.read(buffer,0,1024)) > -1) zos.write(buffer,0,bytecount);
			zos.closeEntry();
			zos.flush();
			zos.close();
			fos.close();
		}
		catch (NullPointerException e)
		{
			System.out.println("ERROR: Null Pointer Exception: "+e);
		}
		catch (FileNotFoundException e)
	  {
	    e.printStackTrace();
	  }
		catch (IOException e)
	  {
			System.out.println("ERROR: IO Pointer Exception: "+e);
	    e.printStackTrace();
	  }
	}


	/*
	The following function writes a specified entry to pStream.
	*/
	public void putentry(ZipOutputStream pStream, String pEntryName, byte pData[])
	{
		try
		{
			ZipOutputStream zos = pStream;
			ZipEntry entry = new ZipEntry(pEntryName);
			zos.putNextEntry(entry);
			
			byte[] buffer = new byte[1024];
			int bytecount = 0;
			ByteArrayInputStream bis = new ByteArrayInputStream(pData);
			while ((bytecount = bis.read(buffer,0,1024)) > -1) zos.write(buffer,0,bytecount);
		}
		catch (NullPointerException e)
		{
			System.out.println("ERROR: Null Pointer Exception: "+e);
		}
		catch (FileNotFoundException e)
	  {
	    e.printStackTrace();
	  }
		catch (IOException e)
	  {
			System.out.println("ERROR: IO Pointer Exception: "+e);
	    e.printStackTrace();
	  }
	}


	/*
	The following function retrieves a specified entry from a zip file using the Entry Name.
	(jmg008 - updated to use ZipInputStream class rather than ZipFile class)
	*/
	public byte[] getentry(String pFilename, String pEntryName)
	{
		byte compval[] = null;
		try
		{
			ZipEntry entry = null;
		  ZipInputStream zi = new ZipInputStream(new BufferedInputStream(new FileInputStream(pFilename)));
		  if (zi != null)
		  {
			entry = findEntry(zi, pEntryName);

		  	if (entry != null)
		  	{
		  		int len = 0;
					byte[] buffer = new byte[1024];
					int entrylen = (int) zi.available();
			    ByteArrayOutputStream bos = new ByteArrayOutputStream(entrylen);
			  	while((len = zi.read(buffer)) >= 0) bos.write(buffer, 0, len);
			  	compval = bos.toByteArray();
		      if (compval == null) // jmg0067
		      {
		      	System.out.println("Error: no data was read from zipentry "+pEntryName);
		      }
		      zi.close();
		  	}
		  }	
		}
		catch (NullPointerException e)
		{
			System.out.println("ERROR: Null Pointer Exception: "+e);
		}
		catch (FileNotFoundException e)
	  {
	    e.printStackTrace();
	  }
		catch (IOException e)
	  {
			System.out.println("ERROR: IO Pointer Exception: "+e);
	    e.printStackTrace();
	  }
		return compval;	
	}


	/*
	The following function retrieves a specified entry from a zip file using the zipEntry class.
	*/
	public byte[] getentry(ZipFile pFile, ZipEntry pEntry)
	{
		byte compval[] = null;
		try
		{
			ZipFile zf = pFile;
			ZipEntry entry = pEntry;
	  	if (entry != null)
	  	{
	  		int len = 0;
				byte[] buffer = new byte[1024];
	  		InputStream instream = zf.getInputStream(entry);
		  	int entrylen = (int)instream.available();
		    ByteArrayOutputStream bos = new ByteArrayOutputStream(entrylen);
		  	while((len = instream.read(buffer)) >= 0) bos.write(buffer, 0, len);
		  	compval = bos.toByteArray();
	      if (compval == null) // jmg0067
	      {
	      	System.out.println("Error: no data was read ");
	      }
	      instream.close();
	  	}
		}
		catch (NullPointerException e)
		{
			System.out.println("ERROR: Null Pointer Exception: "+e);
		}
		catch (FileNotFoundException e)
	  {
	    e.printStackTrace();
	  }
		catch (IOException e)
	  {
			System.out.println("ERROR: IO Pointer Exception: "+e);
	    e.printStackTrace();
	  }
		return compval;	
	}


	/*
	The Following function lists the content of a zip file. The list
	is returned to Omnis in an Object Array.
	(jmg008 - updated to use ZipInputStream class rather than ZipFile class)
	*/
  public Object[] listentries(String pFileName)
	{
		int n = 0;
		Vector<String> entries = null;
		entries = new Vector<String>();
		try
	  {
	    ZipInputStream zi = new ZipInputStream(new BufferedInputStream(new FileInputStream(pFileName)));
	    
	    String zipname = null;
	    ZipEntry entry;

	    while((entry = zi.getNextEntry()) != null) { 

				zipname = entry.getName();					
				entries.addElement(zipname);
				n = n + 1;
			}
	    zi.close();
	  }
		catch (NullPointerException e)
		{
			System.out.println("ERROR: Null Pointer Exception: "+e);
		}
		catch (FileNotFoundException e)
	  {
	    e.printStackTrace();
	  }
		catch (IOException e)
	  {
	    e.printStackTrace();
	  }
	  return entries.toArray();
	}	
  
  /**
   * JMG 23/09/2013
   * Returns a ZipEntry from the ZipInputStream
   **/
  private ZipEntry findEntry(ZipInputStream stream, String name) {
	ZipEntry entry = null;
	try {
		while ((entry = stream.getNextEntry())!=null) {
			if (entry.getName().equals(name))
				return entry;
		}
	} catch (IOException e) {
	}
	
	// No entry with passed name exists in stream:
	return null;
  }
  
  
}
